import com.rockmong.rockmong.Device;
import com.rockmong.rockmong.IO;
import com.sun.jna.ptr.IntByReference;

public class demo_io {
    /** 
     * Launch the application. 
     */  
    public static void main(String[] args) {
    	int ret;
        int[] SerialNumbers = new int[16];
        ret = Device.INSTANCE.Device_Scan(SerialNumbers);
        if (0 > ret) {
            System.out.println("Error: " + ret);
            if (ret == -1003){
                System.out.println("请参考常见问题文件夹里面处理一下权限问题");
            }
            return;
        }
        else if (0 == ret){
            System.out.println("No Device!");
            return;
        }
        else{
            for (int i = 0; i < ret; i++){
                System.out.println("Dev" + i + " SN: " + SerialNumbers[i]);
            }
        }

        int sn = SerialNumbers[0];

        ret = Device.INSTANCE.Device_Open(sn);
        if (0 > ret) {
            System.out.println("Error: " + ret);
            return;
        }

        //控制所有输出端0~7继电器断开（晶体管导通）
        ret = IO.INSTANCE.IO_WritePin_Bit(sn, 0xFFFF);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        //控制所有输出端0~7继电器吸合（晶体管断开）
        ret = IO.INSTANCE.IO_WritePin_Bit(sn, 0x0000);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }

        //读取所有输入端状态
        IntByReference PinState = new IntByReference();
        ret = IO.INSTANCE.IO_ReadPin_Bit(sn, PinState);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        int state = PinState.getValue();
        System.out.printf("PinState (Hex): 0x%08X%n", state);

        ret = Device.INSTANCE.Device_Close(sn);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
    }
}
