#-*- coding: utf-8 -*-
from ctypes import *
import os
import sys
public_path = os.path.normpath(os.path.dirname(os.path.abspath(__file__)) + "/../public")
sys.path.append(public_path)
from librockmong import *
from device import *
from gpio import *
from time import sleep

if __name__ == '__main__':
    SerialNumbers = (c_int * 20)()
    sn = 0
    io_count = 2
    # Scan device
    ret = Device_Scan(byref(SerialNumbers))
    if (0 > ret):
        print("Error: %d"%ret)
        if ret == -1003:
            print("请参考常见问题文件夹下面处理一下权限问题！")
        exit()
    elif(ret == 0):
        print("No device!")
        exit()
    else:
        for i in range(ret):
            print("Dev%d SN: %d"%(i, SerialNumbers[i]))
    
    sn = SerialNumbers[0]# 选择设备0
           
    # 打开设备
    ret = Device_Open(sn)
    if (0 > ret):
        print("error: %d"%ret)
        exit()

    IO_WriteMultiPin_TxStruct = (IO_WriteMultiPin_TxStruct_t*io_count)()
    IO_WriteMultiPin_RxStruct = (IO_WriteMultiPin_RxStruct_t*io_count)()
     
    #控制OUT0~1继电器吸合（晶体管断开）
    for i in range(io_count):
        IO_WriteMultiPin_TxStruct[i].Pin = i
        IO_WriteMultiPin_TxStruct[i].PinState = 1
    ret = IO_WriteMultiPin(sn, IO_WriteMultiPin_TxStruct, IO_WriteMultiPin_RxStruct, io_count)
    if (0 > ret):
        for i in range(io_count):
            print("error: %d"%IO_WriteMultiPin_RxStruct[i].Ret)

    
    IO_ReadMultiOutputPin_TxStruct = (IO_ReadMultiOutputPin_TxStruct_t*io_count)()
    IO_ReadMultiOutputPin_RxStruct = (IO_ReadMultiOutputPin_RxStruct_t*io_count)()
     
    #读取OUT0~1输入状态
    for i in range(io_count):
        IO_ReadMultiOutputPin_TxStruct[i].Pin = i
    ret = IO_ReadMultiOutputPin(sn, IO_ReadMultiOutputPin_TxStruct, IO_ReadMultiOutputPin_RxStruct, io_count)
    if (0 > ret):
        for i in range(io_count):
            print("error: %d"%IO_ReadMultiOutputPin_RxStruct[i].Ret)
    for i in range(io_count):
        print("P%d: %d\t"%(i,IO_ReadMultiOutputPin_RxStruct[i].PinState), end="")

    #控制OUT0~1继电器断开（晶体管导通）
    for i in range(io_count):
        IO_WriteMultiPin_TxStruct[i].Pin = i
        IO_WriteMultiPin_TxStruct[i].PinState = 0
    ret = IO_WriteMultiPin(sn, IO_WriteMultiPin_TxStruct, IO_WriteMultiPin_RxStruct, io_count)
    if (0 > ret):
        for i in range(io_count):
            print("error: %d"%IO_WriteMultiPin_RxStruct[i].Ret)
                 
    #读取OUT0~1输入状态
    for i in range(io_count):
        IO_ReadMultiOutputPin_TxStruct[i].Pin = i
    ret = IO_ReadMultiOutputPin(sn, IO_ReadMultiOutputPin_TxStruct, IO_ReadMultiOutputPin_RxStruct, io_count)
    if (0 > ret):
        for i in range(io_count):
            print("error: %d"%IO_ReadMultiOutputPin_RxStruct[i].Ret)
    for i in range(io_count):
        print("P%d: %d\t"%(i,IO_ReadMultiOutputPin_RxStruct[i].PinState), end="")

    IO_ReadMultiPin_TxStruct = (IO_ReadMultiPin_TxStruct_t*io_count)()
    IO_ReadMultiPin_RxStruct = (IO_ReadMultiPin_RxStruct_t*io_count)()
     
    #读取IN0~1输入状态
    for i in range(io_count):
        IO_ReadMultiPin_TxStruct[i].Pin = i
    ret = IO_ReadMultiPin(sn, IO_ReadMultiPin_TxStruct, IO_ReadMultiPin_RxStruct, io_count)
    if (0 > ret):
        for i in range(io_count):
            print("error: %d"%IO_ReadMultiPin_RxStruct[i].Ret)
    for i in range(io_count):
        print("P%d: %d\t"%(i,IO_ReadMultiPin_RxStruct[i].PinState), end="")
    print("")

    # 关闭设备
    ret = Device_Close(sn)


    
