﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Rockmong;
using System.Threading;

namespace Demo_IO
{
    class Program
    {
        static void Main(string[] args)
        {
            int ret = 0, i;
            int[] SerialNumbers = new int[16];
            int SerialNumber;
            io.IO_Read_Struct_Tx_t[] IO_Read_Struct_Tx = new io.IO_Read_Struct_Tx_t[4];
            io.IO_Read_Struct_Rx_t[] IO_Read_Struct_Rx = new io.IO_Read_Struct_Rx_t[4];
            io.IO_Write_Struct_Tx_t[] IO_Write_Struct_Tx = new io.IO_Write_Struct_Tx_t[4];
            io.IO_Write_Struct_Rx_t[] IO_Write_Struct_Rx = new io.IO_Write_Struct_Rx_t[4];
	
            ret = Device.Device_Scan(SerialNumbers);
            if (ret < 0)
            {
	            Console.Write("Scan error: %d\n", ret);
                return;
            }
            else if (ret == 0)
            {
	            Console.Write("No device\n");
                return;
            }
            else
            {
	            for (i = 0; i < ret; i++)
	            {
		            Console.WriteLine("Dev" + i.ToString() + " SN: " + SerialNumbers[i].ToString());
	            }
            }

            SerialNumber = SerialNumbers[0];

            ret = Device.Device_Open(SerialNumber);
            if (ret < 0)
            {
	            Console.Write("Open error: %d\n", ret);
                return;
            }

            //控制OUT0继电器断开（晶体管导通）
            IO_Write_Struct_Tx[0].Pin = 0;
            IO_Write_Struct_Tx[0].PinState = 0;
            //控制OUT1继电器吸合（晶体管高阻）
            IO_Write_Struct_Tx[1].Pin = 1;
            IO_Write_Struct_Tx[1].PinState = 1;
            //控制OUT2继电器断开（晶体管导通）
            IO_Write_Struct_Tx[2].Pin = 2;
            IO_Write_Struct_Tx[2].PinState = 0;
            //控制OUT3继电器吸合（晶体管高阻）
            IO_Write_Struct_Tx[3].Pin = 3;
            IO_Write_Struct_Tx[3].PinState = 1;
            //同时写入控制
            ret = io.IO_WriteMultiPin(SerialNumber, IO_Write_Struct_Tx, IO_Write_Struct_Rx, 4);
            if (ret < 0)
            {
                Console.WriteLine("Error: " + ret.ToString());
            }

            //读取IN0~IN3状态
            for (i = 0; i < 4; i++)
            {
                IO_Read_Struct_Tx[i].Pin = (Byte)i;
            }
            while (true)
            {
                ret = io.IO_ReadMultiPin(SerialNumber, IO_Read_Struct_Tx, IO_Read_Struct_Rx, 4);
                if (ret < 0)
                {
                    Console.WriteLine("Error: " + ret.ToString());
                }
                for (i = 0; i < 4; i++)
                {
                    Console.Write("IN" + i.ToString() + ": " + IO_Read_Struct_Rx[i].PinState.ToString() + "\t");
                }
                Console.WriteLine();
                Thread.Sleep(500);
            }

            ret = Device.Device_Close(SerialNumber);
            if (ret < 0)
            {
	            Console.Write("Close error: %d\n", ret);
                return;
            }
                     
        }
    }
}
