#include "stdio.h"
#include "device.h"
#include "io.h"

int main(void)
{
	int ret = 0, i;
	int SerialNumbers[16];
	int PinState = 0;
	int sn = 0;
	
	ret = Device_Scan(SerialNumbers);
	if (ret < 0)
	{
		printf("Scan error: %d\n", ret);
		if (ret == -1003)
			printf("请参考常见问题文件夹下面处理一下权限\n");
		return ret;
	}
	else if (ret == 0)
	{
		printf("No device\n");
		return ret;
	}
	else
	{
		for (i = 0; i < ret; i++)
		{
			printf("Dev%d SN: %d\n", i, SerialNumbers[i]);
		}
	}

	sn = SerialNumbers[0];

	// 打开设备
	ret = Device_Open(sn);
	if (ret < 0)
	{
		printf("Error: %d\n", ret);
		return ret;
	}

	// 控制Y0继电器断开（晶体管导通）
	ret = IO_WritePin(sn, 0, 0);
	if (ret < 0)
	{
		printf("Error: %d\n", ret);
		return ret;
	}

	// 控制Y0继电器吸合（晶体管断开）
	ret = IO_WritePin(sn, 0, 1);
	if (ret < 0)
	{
		printf("Error: %d\n", ret);
		return ret;
	}

	// 读取X0输入状态
	ret = IO_ReadPin(sn, 0, &PinState);
	if (ret < 0)
	{
		printf("Error: %d\n", ret);
		return ret;
	}
	printf("Read pin: %d", PinState);
	
	// 关闭设备
	ret = Device_Close(sn);
}
